
//import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;


@SuppressWarnings("serial")
public class DuckyLove extends JPanel implements ActionListener,MouseMotionListener, MouseListener
{
	private Crossbow bow;
	private Target target;
	private ArrayList<Heart> hearts;
	private int score, hits, miss;
	private Timer timer;
	//private AudioClip bell;
	private Clip bell;
	private Image background;
	private BufferedImage heartImg, duckImg;
	private Font font;
	public static int WIDTH=800;
	public static int HEIGHT=650;
	public DuckyLove() {
		super();
		init();
	}
	public void init(){
		timer = new Timer(10,this);
		score = 0;
		hits = 0;
		miss = 0;
		bow=new Crossbow();
		//We load the large files once to save time,
		//getting the resource from the jar file

		try {
			background = ImageIO.read( getClass().getResource("/stuff/background.gif"));
			heartImg = ImageIO.read( getClass().getResource("/stuff/heart.png"));
			duckImg = ImageIO.read( getClass().getResource("/stuff/ducky.gif"));
			URL filepath = getClass().getResource("/stuff/bell.wav");
			String fName = URLDecoder.decode(filepath.getPath(), "UTF-8");
			File bellFile = new File( fName );
			AudioInputStream sound = AudioSystem.getAudioInputStream(bellFile) ;
			bell = AudioSystem.getClip();
			bell.open(sound);
			bell.start();
			bell.setFramePosition(0);
			
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		target=new Target(duckImg);
		hearts = new ArrayList<Heart>();
		timer.start();
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		

		font = new Font("Helvetica", Font.BOLD,  18);       
	}
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		//g.setColor(Color.WHITE);
		//g.fillRect(0, 0, getWidth(),getHeight());
		g.drawImage(background, 0, 0, null);
		bow.draw(g);
		target.draw(g);
		for (Heart h:hearts)
			h.draw(g);
		
		g.setColor(Color.BLUE);
		g.setFont(font);
		g.drawString("Hits: "+hits, 715, 560);
		g.drawString("Misses: "+miss, 690, 585);
		int percent=0;
		if (hits+miss!=0)
			percent=100*hits/(hits+miss);
		g.drawString("Score: "+score+" ("+percent+"%)", 20, 20);
		g.drawString("Angle: "+Math.round(180*bow.getAngle()/Math.PI), 20, 580);

	}
	public void update(Graphics g)
	{
		paint(g); //get rid of flicker with this method
	}

	public void mouseClicked(MouseEvent arg0) {}

	public void mouseEntered(MouseEvent arg0) {}

	public void mouseExited(MouseEvent arg0) {}

	public void mousePressed(MouseEvent arg0) {}

	public void mouseReleased(MouseEvent arg0) {
		// fire a heart
		hearts.add(new Heart(bow.getAngle(), heartImg));
	}

	public void mouseDragged(MouseEvent e) {}

	public void mouseMoved(MouseEvent e) {
		int x=e.getX();
		bow.setX(x);
		repaint();
	}

	public void actionPerformed(ActionEvent arg0) {
		target.move();
		for(Heart h:hearts)
			h.move();
		int i=0;
		while (i<hearts.size()){
			Heart h=hearts.get(i);
			//check for hit
			boolean hit=target.touches(h.area());
			if (hit){
				score+=10*target.getSpeed();
				hits++;
				bell.start();
				bell.setFramePosition(0);
				hearts.remove(h);
			} 
			if (h.getY()<-50){
				score--; 
				miss++;
				hearts.remove(h);
			}else{
				i++;
			}
		}
		repaint();
	}
	public static void main(String[] args) {
		DuckyLove app= new DuckyLove();
		JFrame window = new JFrame("Ducky Love");
		window.setSize(WIDTH, HEIGHT);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		window.getContentPane().add(app);
		window.setVisible(true);

	}

}